#!/bin/bash
# Checks to see if there is a valid upgrade on either the
# PCMCIA or Compact Flash media cards.

check_fw_upgrade()
{
    umount /mnt 2>/dev/null

    devs=`
	while read slot a b c dev d
	do
	    case "$slot" in
		0 | 1 )
		    echo $dev
		    ;;
	    esac
	done </var/run/stab
    `

    for dev in $devs
    do
	mount /dev/${dev}1 /mnt

	if [ -f /mnt/firmware_upgrade/bin/firmware_upgrade.sh ]
	then
	    echo "$dev" >/tmp/upgradeDev
	    return 0
	else
	    umount /mnt
	fi
    done

    return 1
}

# Start the cardmgr with '-f' foreground to force start before continuing.
/sbin/cardmgr -f

if check_fw_upgrade
then
    cp /mnt/firmware_upgrade/bin/firmware_upgrade.sh /tmp
    sh /tmp/firmware_upgrade.sh
else
    echo "Firmware upgrade not present, continuing with unit startup..."
fi 
